/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.udp;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.udp.IncomingDatagramPortOwner;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class OutgoingDatagramPortOwner {
    private static final String TRACE_MASKD = "XFCSODPD";
    private static final String TRACE_MASKF = "XFCSODPF";
    private static final String TRACE_MASKT = "XFCSODPT";
    private static OutgoingDatagramPortOwner _singleton;
    private DatagramSocket outSocket;
    private static boolean allowBroadcastOverPublicNetworks;
    private DatagramSocket[] outSockets;
    private boolean useTestCode = false;
    private static MachineId machineId;

    private OutgoingDatagramPortOwner() {
        this.buildSocket();
    }

    private synchronized void buildSocket() {
        block17: {
            boolean deprecated = true;
            if (deprecated) {
                return;
            }
            if (this.useTestCode) {
                try {
                    if (this.outSockets != null || machineId == null) break block17;
                    int count = 0;
                    int i = 0;
                    while (i < machineId.getNicAddresses().length) {
                        if (!machineId.getPublicNetworkIndicators()[i] || allowBroadcastOverPublicNetworks) {
                            ++count;
                        }
                        ++i;
                    }
                    this.outSockets = new DatagramSocket[count];
                    count = 0;
                    int i2 = 0;
                    while (i2 < machineId.getNicAddresses().length) {
                        if (!machineId.getPublicNetworkIndicators()[i2] || allowBroadcastOverPublicNetworks) {
                            if (IncomingDatagramPortOwner.isUseMulticast()) {
                                this.outSockets[count] = new MulticastSocket();
                                ((MulticastSocket)this.outSockets[count]).setTimeToLive(5);
                                ((MulticastSocket)this.outSockets[count]).joinGroup(InetAddress.getByName("225.4.5.6"));
                                ((MulticastSocket)this.outSockets[count]).setInterface(machineId.getNicAddresses()[i2]);
                            } else {
                                this.outSockets[count] = new DatagramSocket();
                                Trace.trace(TRACE_MASKF, "created new outSocket");
                            }
                            ++count;
                        }
                        ++i2;
                    }
                }
                catch (SocketException se) {
                    Trace.trace(TRACE_MASKF, se);
                    this.outSockets = null;
                }
                catch (IOException ioe) {
                    Trace.trace(TRACE_MASKF, ioe);
                    this.outSockets = null;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e);
                    this.outSockets = null;
                }
            } else {
                try {
                    if (this.outSocket != null) break block17;
                    if (IncomingDatagramPortOwner.isUseMulticast()) {
                        this.outSocket = new MulticastSocket();
                        ((MulticastSocket)this.outSocket).setTimeToLive(5);
                        ((MulticastSocket)this.outSocket).joinGroup(InetAddress.getByName("225.4.5.6"));
                        ((MulticastSocket)this.outSocket).setInterface(InetAddress.getLocalHost());
                        break block17;
                    }
                    this.outSocket = new DatagramSocket();
                }
                catch (SocketException se) {
                    this.outSocket = null;
                }
                catch (IOException ioe) {
                    this.outSocket = null;
                }
            }
        }
    }

    public static synchronized OutgoingDatagramPortOwner getOutgoingDatagramPortOwner() {
        if (_singleton == null) {
            _singleton = new OutgoingDatagramPortOwner();
        }
        return _singleton;
    }

    public void send(DatagramPacket packet) {
        block9: {
            block8: {
                if (!this.useTestCode) break block8;
                if (this.outSockets == null) {
                    this.buildSocket();
                }
                if (this.outSockets == null) break block9;
                int i = 0;
                while (i < this.outSockets.length) {
                    if (this.outSockets[i] != null) {
                        try {
                            this.outSockets[i].send(packet);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                break block9;
            }
            if (this.outSocket == null) {
                this.buildSocket();
            }
            if (this.outSocket == null) break block9;
            try {
                this.outSocket.send(packet);
            }
            catch (IOException ioe) {}
        }
    }

    public void closeSocket() {
        block6: {
            block5: {
                if (!this.useTestCode) break block5;
                if (this.outSockets == null) break block6;
                int i = 0;
                while (i < this.outSockets.length) {
                    try {
                        this.outSockets[i].close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++i;
                }
                this.outSockets = null;
                break block6;
            }
            if (this.outSocket == null) break block6;
            try {
                this.outSocket.close();
                this.outSocket = null;
            }
            catch (Exception e) {}
        }
    }

    public void restart() {
        if (this.useTestCode) {
            if (this.outSockets == null) {
                this.buildSocket();
            }
        } else if (this.outSocket == null) {
            this.buildSocket();
        }
    }

    public void networkSettingsChanged() {
        this.closeSocket();
        this.buildSocket();
        MachineId tmp = null;
        try {
            tmp = FcsServer.getFcsServer().getLocalMachineId();
            if (tmp != null) {
                machineId = tmp;
            }
        }
        catch (Exception e) {}
    }

    public static void setAllowBroadcastOverPublicNetworks(boolean newVal) {
        Trace.trace(TRACE_MASKF, "setAllowBroadcastOverPublicNetworks(" + newVal + ")");
        if (newVal != allowBroadcastOverPublicNetworks) {
            allowBroadcastOverPublicNetworks = newVal;
            OutgoingDatagramPortOwner.getOutgoingDatagramPortOwner().closeSocket();
            OutgoingDatagramPortOwner.getOutgoingDatagramPortOwner().buildSocket();
        }
    }

    public static void setMachineId(MachineId newMachineId) {
        machineId = newMachineId;
    }
}

